ResizableBox = copy_table(Shape)

--[[
ResizableBox.sample_def = {
    type = "ResizableBox",
    bitmap = "gfx/box_arrow_rb",
    x = 454, y = 566, z = 2000,
    font = "story15",
    text = "Lorem ipsum dolor sit amet consectetuer Lorem Praesent enim ante hendrerit. Tellus velit tempor et nec nibh.",
    padding = 10,
    text_w = 250,
}
--]]


function ResizableBox:init(def, view)
    Shape.init(self, def, view, true)

    self.bitmap = gfx_load_bitmap(def.bitmap)

    self.ltw, self.lth = gfx_sprite_params(self.bitmap, "lt")
    self.mtw, self.mth = gfx_sprite_params(self.bitmap, "mt")
    self.rtw, self.rth = gfx_sprite_params(self.bitmap, "rt")
    self.lmw, self.lmh = gfx_sprite_params(self.bitmap, "lm")
    self.mmw, self.mmh = gfx_sprite_params(self.bitmap, "mm")
    self.rmw, self.rmh = gfx_sprite_params(self.bitmap, "rm")
    self.lbw, self.lbh = gfx_sprite_params(self.bitmap, "lb")
    self.mbw, self.mbh = gfx_sprite_params(self.bitmap, "mb")
    self.rbw, self.rbh = gfx_sprite_params(self.bitmap, "rb")

    self.w, self.h, self.cx, self.cy = gfx_sprite_params(self.bitmap, "complete")
    --self.w, self.h = gfx_sprite_params(self.bitmap, "complete")
    self.w, self.h, self.window_x, self.window_y = gfx_sprite_params(self.bitmap, "window")
    
    self.alpha = 0
    self.fade_in = 0.3

    self.font = def.font
    self.align = "vcenter center"
    self.text = def.text
    self.padding = def.padding or 0
    self.text_w = def.text_w or 250
    self.fade_x_speed = def.fade_x_speed or 10
    self.fade_y_speed = def.fade_y_speed or 10


    self.scale_x = math.max(1, math.ceil( (self.text_w + self.padding * 2 - self.w + self.mtw) / self.mtw))
    local w
    w, self.text_h = gfx_text_size(self.font, self.text, self.align, self.text_w)
    
    self.scale_y = math.max(1, math.ceil( (self.text_h + self.padding * 2 - self.h + self.lmh) / self.lmh))
    
    self.w = self.w + (self.scale_x - 1) * self.mtw
    self.h = self.h + (self.scale_y - 1) * self.lmh
    self.cx = self.cx + (self.scale_x - 1) * self.mtw
    self.cy = self.cy + (self.scale_y - 1) * self.lmh

    self.text_x = self.window_x + math.floor(self.w / 2)
    self.text_y = self.window_y + math.floor(self.h / 2)
    
    local area = {
        x0 = self.window_x,
        y0 = self.window_y,
        x1 = self.window_x + self.w - 1,
        y1 = self.window_y + self.h - 1,
    }

    self:create_area(area)
end


function ResizableBox:destroy()
    gfx_release_bitmap(self.bitmap)
end


function ResizableBox:update(dt)
    if self.fade_in then
        self.fade_in = self.fade_in - dt
        if self.fade_in <= 0 then
            self.fade_in = nil
            self.alpha = 1
        else
            self.alpha = math.min(1, (0.3 - self.fade_in) / 0.3)
        end
    end

    if self.fade_out then
        self.fade_out = self.fade_out - dt
        if self.fade_out <= 0 then
            self.to_destroy = true
        else
            self.alpha = math.max(0, self.fade_out / 0.3)
        end
    end
end


function ResizableBox:render()
    local sx = self.x - (1 - self.alpha) * self.fade_x_speed
    local sy = self.y - (1 - self.alpha) * self.fade_y_speed
    local x1 = sx - self.cx
    local x2 = sx - self.cx + self.ltw
    local x3 = sx - self.cx + self.ltw + self.mtw * self.scale_x
    local y1 = sy - self.cy
    local y2 = sy - self.cy + self.lth
    local y3 = sy - self.cy + self.lth + self.lmh * self.scale_y

    gfx_render_sprite(self.bitmap, "lt", x1, y1, self.alpha)
    gfx_render_sprite(self.bitmap, "mt", x2, y1, self.alpha, 0, self.scale_x, 1)
    gfx_render_sprite(self.bitmap, "rt", x3, y1, self.alpha)
    gfx_render_sprite(self.bitmap, "lm", x1, y2, self.alpha, 0, 1, self.scale_y)
    gfx_render_sprite(self.bitmap, "mm", x2, y2, self.alpha, 0, self.scale_x, self.scale_y)
    gfx_render_sprite(self.bitmap, "rm", x3, y2, self.alpha, 0, 1, self.scale_y)
    gfx_render_sprite(self.bitmap, "lb", x1, y3, self.alpha)
    gfx_render_sprite(self.bitmap, "mb", x2, y3, self.alpha, 0, self.scale_x, 1)
    gfx_render_sprite(self.bitmap, "rb", x3, y3, self.alpha)
    
    --gfx_render_text(self.font, x1 + math.floor((self.w - self.text_w) / 2), y1 + math.floor(self.h / 2), self.text, self.align, self.text_w, nil, self.alpha)
    gfx_render_text(self.font, x1 + self.text_x, y1 + self.text_y, self.text, self.align, self.text_w, nil, self.alpha, "000000")
end


function ResizableBox:mouse_left_click()
    self.fade_out = 0.3
end
